

CompScans_05toAll <- function(datafA,dataf){

  
  dataf$PTM_Final_prob <- dataf$Score*dataf$PTM.Score
  
  dataf$Unique_scan <- str_remove(dataf$Spectrum, '.mzML')
  datafA$Unique_scan <-datafA$Spectrum
  datafA$Sequence <- datafA$Peptide
  dataf$Sequence <- dataf$Peptide
  
library(plyr)
datafA_pform <- binAdjustPform(datafA)
detach(package:plyr)
datafA_pform <- FLR_Adj(datafA_pform)

datafA_pform_05 <- datafA_pform[1:max(which(datafA_pform$FLR_Adj_Score<=0.05)),]

ReduceddatafA_05 <- subset(datafA_pform_05,select = c(Unique_scan,Sequence,Amino,Bin_Adjusted_Score, PTM.positions))

ReduceddatafA_05 <- ReduceddatafA_05 %>% dplyr::rename(
  pASTY_Score = Bin_Adjusted_Score
)
Reduceddataf <- subset(dataf,select = c(Unique_scan,Sequence,PTM_Final_prob, PTM.positions))

Reduceddataf <- Reduceddataf %>% dplyr::rename(
  SequenceSTY = Sequence,
  PTM.positionsSTY= PTM.positions,
  pSTY_Score = PTM_Final_prob
)


dataf_Merged_05 <- merge(x=ReduceddatafA_05,y=Reduceddataf,by="Unique_scan", all.x = TRUE)
dataf_Merged_05<- dataf_Merged_05 %>% group_by(Unique_scan) %>% dplyr::mutate(count_S = n())
dataf_Merged_05<- dataf_Merged_05 %>% group_by(Unique_scan) %>% dplyr::mutate(count_M = n_distinct(PTM.positions))


dataf_Merged_05$SeqMatch <- ifelse(dataf_Merged_05$Sequence==dataf_Merged_05$SequenceSTY,1,0)
dataf_Merged_05$PTM_Match <- ifelse(dataf_Merged_05$Sequence==dataf_Merged_05$SequenceSTY&dataf_Merged_05$PTM.positions==dataf_Merged_05$PTM.positionsSTY,1,0)
dataf_Merged_05$SiteID <- paste0(dataf_Merged_05$Unique_scan,"_", dataf_Merged_05$PTM.positions)


# Results #
###########

NoMatchSeq_05 <- subset(dataf_Merged_05,SeqMatch==0 | is.na(SeqMatch))

MatchSeq_05 <- subset(dataf_Merged_05,SeqMatch==1 )

Scans_NMSeq_05 <- length(unique(NoMatchSeq_05$Unique_scan))

Scans_MSeq_05 <- length(unique(MatchSeq_05$Unique_scan))

MatchSeq_05 <-MatchSeq_05 %>% group_by(Unique_scan) %>%  mutate(sum_matches=sum(PTM_Match))

MatchSeq_05$Flag <- MatchSeq_05$count_M - MatchSeq_05$sum_matches

MatchSeq_MSites_05 <- subset(MatchSeq_05,Flag==0)

MatchSeq_NoMSites_05 <- subset(MatchSeq_05,Flag==1)

Scans_MSeq_NMSite_05 <- length(unique(MatchSeq_NoMSites_05$SiteID))

Scans_MSeq_MSite_05 <- length(unique(MatchSeq_MSites_05$SiteID))

NoMatchSeq_Alternative_05 <- subset(NoMatchSeq_05,PTM_Match==0)

NoMatchSeq_NoAlternative_05 <- subset(NoMatchSeq_05,is.na(PTM_Match))

Scans_NMSeq_Alternative_05 <- length(unique(NoMatchSeq_Alternative_05$SiteID))

Scans_NMSeq_NoAlternative_05 <- length(unique(NoMatchSeq_NoAlternative_05$SiteID))

Results_05 <- rbind(Scans_NMSeq_05,Scans_MSeq_05,Scans_MSeq_NMSite_05,Scans_MSeq_MSite_05,Scans_NMSeq_Alternative_05,Scans_NMSeq_NoAlternative_05)


return(list(Results_05))

}